<?php defined('PF_VERSION') OR exit('Access denied');?>
<?php

/*
 * 
 * @package  PageFlex
 * @author  PageFlex Team (technical@vinamost.net)
 * @copyright PageFlex Team
 * @link  http://page-flex.com
 * @since  Version 1.0
 * @filesource
 *
 */

$edit = new Pf_User();
$show = '';
$formname = __("Edit User", "user");
    $ref=array('admin-page'=>'users');
    if(!empty($_GET['page'])) $ref['page']  =   $_GET['page'];
    if(!empty($_GET['username'])) $ref['username']    =   $_GET['username'];
    if(!empty($_GET['email'])) $ref['email']    =   $_GET['email'];
    if(!empty($_GET['role'])) $ref['role']    =   $_GET['role'];
    if(!empty($_GET['active'])) $ref['active']    =   $_GET['active'];
    if(!empty($_GET['publish'])) $ref['publish']    =   $_GET['publish'];
if (isset($_GET['id'])) {
    $edit->set_id($_GET['id']);
    $user_infomation = $edit->get_info('user_name,user_email,user_displayname,user_role,user_activation,user_login_time,user_login_ip,public_profile');
    foreach ($user_infomation as $user) {
        $username   = $user['user_name'];
        $email      = $user['user_email'];
        $displayname = $user['user_displayname'];
        $role       = $user['user_role'];
        $active     = $user['user_activation'] == 2 ? FALSE : TRUE;
        $public     = $user['public_profile'] == 2? FALSE : TRUE;
        $login_time =    $user['user_login_time']>0?date(get_configuration('long_date'),strtotime($user['user_login_time'])):__("Not login yet!", "user");
    }   $login_ip   =    $user['user_login_ip'];
    if (isset($_POST['user-email'])) {
        $v = Pf::validator();
        $_POST = $v->sanitize($_POST);
        $rules  =   array(
            "user-email" => "required|valid_email",
        );
        if(!empty($_POST['password']))  $rules['password']  =   "required|max_len,20|min_len,".  get_configuration('pass_length','pf_user');
        if(!empty($_POST['repassword']))  $rules['repassword']  =   "required|max_len,20|min_len,".get_configuration('pass_length','pf_user');
        $v->validation_rules($rules);
        $v->filter_rules(array(
            'displayname' => 'trim|sanitize_string',
            'password' => 'trim',
            'user-email' => 'trim|sanitize_email'
        ));
        $validate = $v->run($_POST);


        if ($validate === false) {
            $error = $v->get_readable_errors(false);
        } else {
            $eemail = $_POST['user-email'];
            $displayname = isset($_POST['displayname']) ? $_POST['displayname'] : '';
            $role = isset($_POST['role']) ? $_POST['role'] : 5;
            $active = isset($_POST['activation']) ? 1 : 2;
            $public = isset($_POST['public_profile']) ? 1: 2;
            if (!$edit->check_email($eemail)) {
                $error['user-email'][0] = __("Email is already in use!", "user");
            }
            $data = array(
                'user-email' => $eemail,
                'displayname' => $displayname,
                'role' => $role,
                'activation' => $active,
                'public'    =>  $public
            );
            if (!empty($_POST['password'])) {
                $repassword = !empty($_POST['repassword']) ? $_POST['repassword'] : '';
                if ($_POST['password'] != $repassword) {
                    $error['repassword'][0] = __("Passwords do not match!", "user");
                } else {
                    $data['password'] = $_POST['password'];
                }
            }
        }
        if (!empty($error)) {
            $show.=notif(__("Please review your information!", "user"));
        } else {
            $edit->add_data($data);
            $edit->save();
            $show.=notif(__('User is updated successfully','user') . "\n", $user);
            $_SESSION['success']=__('User is updated successfully','user');
            header('location: '.  admin_url($ref,false));
        }
    }
    require_once abs_plugin_path(__FILE__) . "/user/views/views-form.php";
} else
    $show.=__("Please select an user", "user");
